/********** 
  ILPS (Iterated Local & Plateau Search) for
  the Minimum Independent Dominating Set Problem

  misc.h

  Copyright 2018 Kazuya Haraguchi
  Released Under the MIT License
  https://opensource.org/licenses/mit-license.php
**********/

char **split(char *s, char c);
int getNumChar(char *s, char c);
void *malloc_e(size_t size);
void swap(void *array, int i, int j, size_t size);
void shuffle(void *array, int n, size_t size);
void outputGraph(FILE *out, Graph G);
void outputSolution(FILE *out, Solution S);
void moveToLeft(Solution S, int sect, int i);
void moveToRight(Solution S, int sect, int i);
void add(Solution S, int i);
void drop(Solution S, int i);
void setNeighborsCounters(Solution S, VertexProxy v, int value);
void setNeighborsColor(Solution S, VertexProxy v, int color);
int updateColor(Graph G, Solution S, Tool T);
bool isFeasible(Graph G, Solution S);
void copySolution(Graph G, Solution S_from, Solution S_to);
void getCommonSeq(Seq &seq, Seq &A, Seq &B);
void getCommonSeqWithBT(Seq &seq, Seq &A, BinTree &BT);
int getVertexWithLowestPenalty(vector<int> &v, int *penalty);
