/********** 
  ILPS (Iterated Local & Plateau Search) for
  the Minimum Independent Dominating Set Problem

  misc.cpp

  Copyright 2018 Kazuya Haraguchi
  Released Under the MIT License
  https://opensource.org/licenses/mit-license.php
**********/

#include "define.h"
#include "misc.h"

char **split(char *s, char c){
  typedef struct list{
    int i;
    struct list *p;
  } List;
  char **str;
  List head,*tail,*ip;
  int countnum=0,counts=0;
  int i=0,j=0,i0=0;
  head.i=-1;
  head.p=NULL;
  tail=&head;
  while(s[i]!='\0'){
    if(s[i]==c){
      ip=(List*)malloc_e(sizeof(List));
      ip->i=countnum;
      ip->p=NULL;
      tail->p=ip;
      tail=ip;
      countnum=-1;
      counts++;
    }
    countnum++;
    i++;
  }
  ip=(List*)malloc_e(sizeof(List));
  ip->i=countnum;
  ip->p=NULL;
  tail->p=ip;
  tail=ip;
  str=(char**)malloc_e((counts+1)*sizeof(char*));
  ip=&head;
  do{
    int k=0;
    ip=ip->p;
    str[j]=(char*)malloc_e(((ip->i)+1)*sizeof(char));
    for(i=i0;i<i0+ip->i;i++){
      str[j][k]=s[i];
      k++;
    }
    str[j][k]='\0';
    i0+=ip->i+1;
    j++;
  }while(ip->p!=NULL);
  // free memory
  tail = head.p;
  while(tail != NULL){
    ip = tail->p;
    free(tail);
    tail = ip;
  }
  return str;
}


int getNumChar(char *s, char c){
  int numChar=0, k=0;
  while(s[k] != '\0'){
    if(s[k] == c)
      numChar++;
    k++;
  }
  return numChar;
}


void *malloc_e(size_t size){
  void *s;
  if ((s=malloc(size)) == NULL) {
    fprintf(stderr, "malloc : Not enough memory.\n");
    exit(EXIT_FAILURE);
  }
  return s;
}


void swap(void *array, int i, int j, size_t size){
  size_t r;
  char tmp;
  for(r=0;r<size;r++){
    tmp = ((char*)array)[i*size+r];
    ((char*)array)[i*(int)size+r] = ((char*)array)[j*(int)size+r];
    ((char*)array)[j*(int)size+r] = tmp;
  }
}


void shuffle(void *array, int n, size_t size){
  for(int i=0;i<n;i++){
    int j = (int)((double)i + genrand_real2()*(double)(n-i));
    swap(array, i, j, size);
  }     
}

void outputGraph(FILE *out, Graph G){
  int i;
  fprintf(out, "# |V|=%d\n", G->n);
  fprintf(out, "# |E|=%d\n", G->m);
  for(i=0;i<G->n;i++){
    fprintf(out, "Vertex %d ->", G->V[i]->id+1);
    for(auto itr=G->V[i]->AT.begin(); itr!=G->V[i]->AT.end(); ++itr)
      fprintf(out, " %d", itr->first+1);
    fprintf(out, "\n");
  }
}


void outputSolution(FILE *out, Solution S){
  int sect,i;
  for(sect=SECT_SOL;sect<SECTS;sect++){
    switch(sect){
    case SECT_SOL:  fprintf(out, "Sol"); break;
    case SECT_FREE: fprintf(out, "Free"); break;
    case SECT_ONE:  fprintf(out, "1-tight"); break;
    case SECT_TWO:  fprintf(out, "2-tight"); break;
    default: fprintf(out, "More"); break;
    }
    fprintf(out, " [%d]:", S->num[sect]);
    for(i=0;i<S->num[sect];i++)
      fprintf(out, " %d", S->Order[sect][i]->v->id+1);
    fprintf(out, "\n");
  }
}


void moveToLeft(Solution S, int orig_sect, int i){
  VertexProxy x,tail;
  int dest_sect;
  x = S->Order[orig_sect][i];
  tail = S->Order[orig_sect][S->num[orig_sect]-1];
  if(orig_sect==SECT_FREE){
    x->isSol = true;
    dest_sect = SECT_SOL;
  }
  else{
    x->tightness--;
    switch(x->tightness){
    case 0: dest_sect = SECT_FREE; break;
    case 1: dest_sect = SECT_ONE; break;
    case 2: dest_sect = SECT_TWO; break;
    default: return;
    }
  }
  // move x to dest_sect
  S->Order[dest_sect][S->num[dest_sect]] = x;
  x->sect = dest_sect;
  x->order = S->num[dest_sect];
  S->num[dest_sect]++;
  // move tail to x's last position
  if(x!=tail){
    S->Order[orig_sect][i] = tail;
    tail->order = i;
  }
  S->num[orig_sect]--;
}


void moveToRight(Solution S, int orig_sect, int i){
  VertexProxy x,tail;
  int dest_sect;
  x = S->Order[orig_sect][i];
  tail = S->Order[orig_sect][S->num[orig_sect]-1];
  if(orig_sect==SECT_SOL){
    x->isSol = false;
    x->tightness = 0;
    dest_sect = SECT_FREE;
  }
  else{
    x->tightness++;
    switch(x->tightness){
    case 1: dest_sect = SECT_ONE; break;
    case 2: dest_sect = SECT_TWO; break;
    case 3: dest_sect = SECT_MORE; break;
    default: return;
    }
  }
  // move x to dest_sect
  S->Order[dest_sect][S->num[dest_sect]] = x;
  x->sect = dest_sect;
  x->order = S->num[dest_sect];
  S->num[dest_sect]++;
  // move tail to x's last position
  if(x!=tail){
    S->Order[orig_sect][i] = tail;
    tail->order = i;
  }
  S->num[orig_sect]--;
}


void add(Solution S, int i){
  VertexProxy x,y;
  x = S->Order[SECT_FREE][i];
  moveToLeft(S, SECT_FREE, i);
  for(auto itr=x->v->AL.begin(); itr!=x->v->AL.end(); ++itr){
    y = S->X[*itr];
#ifdef DEBUG
    if(y->isSol){
      fprintf(stderr, "error: you tried to add a vertex that has a solution neighbor.\n");
      exit(EXIT_FAILURE);
    }
#endif
    moveToRight(S, y->sect, y->order);
  }
}


void drop(Solution S, int i){
  VertexProxy x,y;
  x = S->Order[SECT_SOL][i];
  moveToRight(S, SECT_SOL, i);
  for(auto itr=x->v->AL.begin(); itr!=x->v->AL.end(); ++itr){
    y = S->X[*itr];
    moveToLeft(S, y->sect, y->order);
  }
}

void setNeighborsCounters(Solution S, VertexProxy v, int value){
  for(auto itr=v->v->AL.begin(); itr!=v->v->AL.end(); ++itr)
    S->X[*itr]->counter = value;
}

void setNeighborsColor(Solution S, VertexProxy v, int color){
  for(auto itr=v->v->AL.begin(); itr!=v->v->AL.end(); ++itr)
    S->X[*itr]->color = color;
}

int updateColor(Graph G, Solution S, Tool T){
  T->color++;
  if(T->color==MAX_COLOR){
    int i;
    for(i=0;i<G->n;i++)
      S->X[i]->color = INI_COLOR;
    T->color = INI_COLOR+1;
  }
  return T->color;
}
bool isFeasible(Graph G, Solution S){
  bool flag=true,innerflag;
  int i,j,tightness;
  for(i=0;i<G->n;i++){
    if(S->X[i]->isSol==true)
      innerflag = true;
    else
      innerflag = false;
    tightness = 0;
    for(auto itr=S->X[i]->v->AL.begin(); itr!=S->X[i]->v->AL.end(); ++itr){
      j = *itr;
      if(S->X[j]->isSol==true)
	tightness++;
      if(S->X[i]->isSol==true && S->X[j]->isSol==true){
	innerflag = false;
	break;
      }
      if(S->X[i]->isSol==false && S->X[j]->isSol==true)
	innerflag = true;
    }
    if(innerflag==false)
      return false;
    if(S->X[i]->isSol==false && S->X[i]->tightness!=tightness){
      cout << S->X[i]->tightness << " " << tightness << "\n";
      return false;
    }
  }
  return flag;
}


void copySolution(Graph G, Solution S_from, Solution S_to){
  int i,j,s;
  for(i=0;i<G->n;i++){
    S_to->X[i]->sect = S_from->X[i]->sect;
    S_to->X[i]->order = S_from->X[i]->order;
    S_to->X[i]->counter = 0;
    S_to->X[i]->color = INI_COLOR;
    S_to->X[i]->tightness = S_from->X[i]->tightness;
    S_to->X[i]->isSol = S_from->X[i]->isSol;
  }
  for(s=0;s<SECTS;s++){
    S_to->num[s] = S_from->num[s];
    for(i=0;i<S_to->num[s];i++){
      j = S_from->Order[s][i]->v->id;
      S_to->Order[s][i] = S_to->X[j];
    }
  }
}

void getCommonSeq(Seq &seq, Seq &A, Seq &B){
  int i=0,j=0;
  int Asize=A.size();
  int Bsize=B.size();
  while(i<Asize && j<Bsize){
    if(A[i]<B[j])
      i++;
    else if(A[i]>B[j])
      j++;
    else{
      seq.push_back(A[i]);
      i++;
      j++;
    }
  }
}

void getCommonSeqWithBT(Seq &seq, Seq &A, BinTree &BT){
  BinTree::iterator itr=BT.begin();
  int i=0;
  int Asize=A.size();
  while(i<Asize && itr!=BT.end()){
    if(A[i]<itr->first)
      i++;
    else if(A[i]>itr->first)
      itr++;
    else{
      seq.push_back(A[i]);
      i++;
      itr++;
    }
  }
}

int getVertexWithLowestPenalty(vector<int> &v, int *penalty){
  int size;
  if(v.size()==1)
    return 0;
  else if(v.size()==2){
    if(penalty[v[0]]<penalty[v[1]])
      return 0;
    else if(penalty[v[0]]>penalty[v[1]])
      return 1;
    if(genrand_real2()<0.5)
      return 0;
    return 1;
  }
  vector<int> L;
  int lowest=INT_MAX;
  size = v.size();
  for(int i=0;i<size;i++)
    if(penalty[v[i]]<lowest){
      L.clear();
      L.push_back(i);
      lowest = penalty[v[i]];
    }
    else if(penalty[v[i]]==lowest)
      L.push_back(i);
  size = L.size();
  return L[(int)(genrand_real2()*(double)size)];
}
