/********** 
  ILPS (Iterated Local & Plateau Search) for
  the Minimum Independent Dominating Set Problem

  define.h

  Copyright 2018 Kazuya Haraguchi
  Released Under the MIT License
  https://opensource.org/licenses/mit-license.php
**********/

#define DEBUG
#undef DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <iostream>
#include <unordered_map> // hash
#include <map>           // red-black tree
#include <queue>
#include <vector>
#include <algorithm>
using namespace std;

#include "mt19937ar.h"
double cpu_time();

#define MAXLEN_MSG 256

/***********************************************************/
#define INI_SEED   1
#define INI_TIME   -1.0
#define INI_INIT   1
#define INI_NU     3
#define INI_ITRMAX INT_MAX
#define INI_DELAY  32

typedef struct _ParamSet *ParamSet;
struct _ParamSet{
  int seed;    // random seed
  double time; // time limit
  int init;    // initial solution (0:random, 1:greedy)
  int nu;      // expected number of forcibly added vertices 
  int itrmax;  // iteration times
  int delay;   // penalty delay
};
/***********************************************************/

typedef unordered_map<int, int> Hash;
typedef map<int, int> BinTree;
typedef vector<int> Seq;

/***********************************************************/
typedef struct _Vertex *Vertex;
typedef struct _Graph *Graph;
typedef struct _VertexProxy *VertexProxy;
typedef struct _Solution *Solution;
typedef struct _Tool *Tool;

struct _Vertex{
  int id;     // vertex id
  BinTree AT; // binary tree of ids of adj vertices
  Seq AL;     // adjacency list of ids of adj vertices 
  int w;      // weight (for future extension)
  int deg;
  int *R;     // shuffled {0,...,deg-1}  
};

struct _Graph{
  Vertex *V;     // array of vertices
  int n;         // number of vertices
  int m;         // number of edges
};

struct _VertexProxy{
  Vertex v;
  int sect;
  int order; 
  int counter;   // counter
  int color;     // color
  int tightness; // tightness
  bool isSol;    // whether it is a solution vertex or not
};

#define SECTS     5
#define SECT_SOL  0
#define SECT_FREE 1
#define SECT_ONE  2
#define SECT_TWO  3
#define SECT_MORE 4

struct _Solution{
  VertexProxy *X;
  VertexProxy *Order[SECTS];
  int num[SECTS];
};

#define INI_COLOR 0
#define MAX_COLOR INT_MAX

struct _Tool{
  double start_time;
  int t;             // iteration times
  int itr_tb;
  double time_tb;
  bool update;       // whether incumbent solution is updated
  int t_p;           // counter for penalty update
  int *penalty;      // penalties of vertices
  int *profit;
  int color;
  unsigned int a;    // counter for random accessing neighbors 
};

